/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.udf;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import DE.siemens.ad.udf.EditUDFFigure;
import DE.siemens.ad.udf.LogoDrawingUDF;
import DE.siemens.ad.udf.ResizeHandles;
import DE.siemens.ad.udf.UDFBoxFigure;
import java.awt.Rectangle;
import java.util.Vector;

public class ResizeUDFBoxHandles
extends ResizeHandles {
    public void addHandles(Figure f, Vector handles, int minWidth, int minHeight) {
        this.minHeight = minHeight;
        this.minWidth = minWidth;
        handles.addElement(new SouthEastUDFBoxHandle(f));
        handles.addElement(new SouthWestUDFBoxHandle(f));
        handles.addElement(new NorthEastUDFBoxHandle(f));
        handles.addElement(new NorthWestUDFBoxHandle(f));
    }

    protected class NorthWestUDFBoxHandle
    extends ResizeHandles.NorthWestHandle {
        NorthWestUDFBoxHandle(Figure owner) {
            super(owner);
        }

        public void invokeStep(int x, int y, int anchorX, int anchorY, DrawingView view) {
            Rectangle displaybox = ((LogoDrawingUDF)view.drawing()).displayBox();
            int minX = displaybox.x;
            int minY = displaybox.y;
            int udfBoxStroke = ((UDFBoxFigure)this.owner()).getStrokeWidth();
            if (x > minX) {
                x = minX;
            } else if (x <= 0) {
                x = udfBoxStroke;
            }
            if (y > minY) {
                y = minY;
            } else if (y < ((EditUDFFigure)this.owner().container()).getIdTextFigure().displayBox().height) {
                y = ((EditUDFFigure)this.owner().container()).getIdTextFigure().displayBox().height;
            }
            super.invokeStep(x, y, anchorX, anchorY, view);
        }
    }

    protected class NorthEastUDFBoxHandle
    extends ResizeHandles.NorthEastHandle {
        NorthEastUDFBoxHandle(Figure owner) {
            super(owner);
        }

        public void invokeStep(int x, int y, int anchorX, int anchorY, DrawingView view) {
            Rectangle displaybox = ((LogoDrawingUDF)view.drawing()).displayBox();
            int maxX = displaybox.x + displaybox.width;
            int minY = displaybox.y;
            double currentZoom = (double)((LogoDrawingView)view).getZoomManager().getZoom() / 100.0;
            int udfBoxStroke = ((UDFBoxFigure)this.owner()).getStrokeWidth();
            int viewRightX = (int)((double)view.getSize().width / currentZoom) - udfBoxStroke;
            if (x < maxX) {
                x = maxX;
            } else if (x > viewRightX) {
                x = viewRightX;
            }
            if (y > minY) {
                y = minY;
            } else if (y < ((EditUDFFigure)this.owner().container()).getIdTextFigure().displayBox().height) {
                y = ((EditUDFFigure)this.owner().container()).getIdTextFigure().displayBox().height;
            }
            super.invokeStep(x, y, anchorX, anchorY, view);
        }
    }

    protected class SouthEastUDFBoxHandle
    extends ResizeHandles.SouthEastHandle {
        SouthEastUDFBoxHandle(Figure owner) {
            super(owner);
        }

        public void invokeStep(int x, int y, int anchorX, int anchorY, DrawingView view) {
            Rectangle displaybox = ((LogoDrawingUDF)view.drawing()).displayBox();
            int maxX = displaybox.x + displaybox.width;
            int maxY = displaybox.y + displaybox.height;
            double currentZoom = (double)((LogoDrawingView)view).getZoomManager().getZoom() / 100.0;
            int udfBoxStroke = ((UDFBoxFigure)this.owner()).getStrokeWidth();
            int viewRightX = (int)((double)view.getSize().width / currentZoom) - udfBoxStroke;
            int viewLowY = (int)((double)view.getSize().height / currentZoom) - udfBoxStroke;
            if (x < maxX) {
                x = maxX;
            } else if (x > viewRightX) {
                x = viewRightX;
            }
            if (y < maxY) {
                y = maxY;
            } else if (y > viewLowY) {
                y = viewLowY;
            }
            super.invokeStep(x, y, anchorX, anchorY, view);
        }
    }

    protected class SouthWestUDFBoxHandle
    extends ResizeHandles.SouthWestHandle {
        SouthWestUDFBoxHandle(Figure owner) {
            super(owner);
        }

        public void invokeStep(int x, int y, int anchorX, int anchorY, DrawingView view) {
            Rectangle displaybox = ((LogoDrawingUDF)view.drawing()).displayBox();
            int minX = displaybox.x;
            int maxY = displaybox.y + displaybox.height;
            double currentZoom = (double)((LogoDrawingView)view).getZoomManager().getZoom() / 100.0;
            int udfBoxStroke = ((UDFBoxFigure)this.owner()).getStrokeWidth();
            int viewLowY = (int)((double)view.getSize().height / currentZoom) - udfBoxStroke;
            if (x > minX) {
                x = minX;
            } else if (x <= 0) {
                x = udfBoxStroke;
            }
            if (y < maxY) {
                y = maxY;
            } else if (y > viewLowY) {
                y = viewLowY;
            }
            super.invokeStep(x, y, anchorX, anchorY, view);
        }
    }
}

